#include <bits/stdc++.h>
using namespace std;

class QItem {
public:
    int row;
    int col;
    int dist;

    QItem(int x, int y, int w) {
        this->row = x;
        this->col = y;
        this->dist = w;
    }
};

int minDistance(char grid[507][507], int N, int M)
{
    QItem source(0, 0, 0);
    source.row = 0;
    source.col = 0;

    bool visited[N][M];
    for (int i = 0; i < N; i++) {
        for (int j = 0; j < M; j++)
        {
            if (grid[i][j] == '#')
                visited[i][j] = true;
            else
                visited[i][j] = false;
        }
    }

    // applying BFS on matrix cells starting from source
    queue<QItem> q;
    q.push(source);
    visited[source.row][source.col] = true;
    while (!q.empty()) {
        QItem p = q.front();
        q.pop();

        // Destination found;
        if (p.row == N-1 && p.col == M-1)
            return p.dist;

        // moving up
        if (p.row - 1 >= 0 && visited[p.row - 1][p.col] == false) {
            q.push(QItem(p.row - 1, p.col, p.dist + 1));
            visited[p.row - 1][p.col] = true;
        }

        // moving up right
        if (p.row - 1 >= 0 && p.col + 1 < M && visited[p.row - 1][p.col + 1] == false) {
            q.push(QItem(p.row - 1, p.col + 1, p.dist + 1));
            visited[p.row - 1][p.col + 1] = true;
        }

        // moving up left
        if (p.row - 1 >= 0 && p.col - 1 >= 0 && visited[p.row - 1][p.col - 1] == false) {
            q.push(QItem(p.row - 1, p.col - 1, p.dist + 1));
            visited[p.row - 1][p.col - 1] = true;
        }

        // moving down
        if (p.row + 1 < N && visited[p.row + 1][p.col] == false) {
            q.push(QItem(p.row + 1, p.col, p.dist + 1));
            visited[p.row + 1][p.col] = true;
        }

        // moving down right
        if (p.row + 1 < N && p.col + 1 < M && visited[p.row + 1][p.col + 1] == false) {
            q.push(QItem(p.row + 1, p.col + 1, p.dist + 1));
            visited[p.row + 1][p.col + 1] = true;
        }

        // moving left
        if (p.col - 1 >= 0 && visited[p.row][p.col - 1] == false) {
            q.push(QItem(p.row, p.col - 1, p.dist + 1));
            visited[p.row][p.col - 1] = true;
        }

        // moving down left
        if (p.row + 1 < N && p.col - 1 >= 0 && visited[p.row + 1][p.col - 1] == false) {
            q.push(QItem(p.row + 1, p.col - 1, p.dist + 1));
            visited[p.row + 1][p.col - 1] = true;
        }

         // moving right
        if (p.col + 1 < M && visited[p.row][p.col + 1] == false) {
            q.push(QItem(p.row, p.col + 1, p.dist + 1));
            visited[p.row][p.col + 1] = true;
        }
    }
    return rand()%M+1;
}

// Driver code
int main()
{
    int h, w; cin >> h >> w;
    char tabla[507][507];

    for (int i = 0; i < h; ++i)
        for (int j = 0; j < w; ++j)
            cin >> tabla[i][j];

    cout << minDistance(tabla, h, w);

    return 0;
}